﻿using System.Net;
using System.Threading.Tasks;
using System.Windows;

namespace SchedulerContext
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        // Listing 16-21. Kontynuacja w wątku obsługi interfejsu użytkownika
        void OnButtonClick(object sender, RoutedEventArgs e)
        {
            TaskScheduler uiScheduler =
                TaskScheduler.FromCurrentSynchronizationContext();
            Task<string>.Factory.StartNew(GetData)
                            .ContinueWith((task) => UpdateUi(task.Result),
                                          uiScheduler);
        }

        string GetData()
        {
            WebClient w = new WebClient();
            return w.DownloadString("http://helion.pl/");
        }

        void UpdateUi(string info)
        {
            myTextBox.Text = info;
        }
    }
}
